/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.util.network;

import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_320;
import pl.kaqvu.util.kaqvuUtil;
import pl.kaqvu.util.network.MessageHandler;
import pl.kaqvu.util.network.WebSocketHandler;

public class WebSocketManager {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final MessageHandler messageHandler = new MessageHandler();
    private WebSocket webSocket;
    private String playerName;
    private boolean registered = false;
    private boolean connecting = false;
    private boolean lastOnlineState = false;
    private String lastServerIp = "";

    public void tick(class_310 client) {
        class_320 session = client.method_1548();
        if (session == null) {
            return;
        }
        String name = session.method_1676();
        if (name == null || name.isEmpty()) {
            return;
        }
        if (!this.registered && !this.connecting) {
            this.playerName = name;
            this.connect();
        }
        if (this.registered && this.webSocket != null) {
            boolean currentOnline = client.field_1724 != null && client.method_1562() != null;
            String currentServerIp = this.getServerStatus(client, currentOnline);
            if (currentOnline != this.lastOnlineState || !currentServerIp.equals(this.lastServerIp)) {
                this.lastOnlineState = currentOnline;
                this.lastServerIp = currentServerIp;
                this.sendRegister();
            }
        }
    }

    private String getServerStatus(class_310 client, boolean online) {
        if (!online) {
            return "";
        }
        if (client.method_1558() != null) {
            return client.method_1558().field_3761;
        }
        if (client.method_1542()) {
            class_1132 server = client.method_1576();
            if (server != null) {
                String worldName = server.method_27728().method_150();
                return "\u015aWIAT: " + worldName;
            }
            return "Singleplayer";
        }
        return "";
    }

    private void connect() {
        this.connecting = true;
        CompletableFuture.runAsync(() -> {
            try {
                this.httpClient.newWebSocketBuilder().buildAsync(URI.create("wss://util.zawrot.pl"), new WebSocketHandler(this)).join();
            }
            catch (Exception e) {
                this.registered = false;
                this.connecting = false;
                this.webSocket = null;
            }
        });
    }

    public void onConnected(WebSocket ws) {
        kaqvuUtil.LOGGER.info("WebSocket connected");
        this.webSocket = ws;
        this.registered = true;
        this.connecting = false;
        this.sendRegister();
        ws.request(1L);
    }

    public void onClosed() {
        this.registered = false;
        this.connecting = false;
        this.webSocket = null;
    }

    public void onMessage(String message) {
        this.messageHandler.handle(message);
    }

    public void sendRegister() {
        if (this.webSocket == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        boolean online = client.field_1724 != null && client.method_1562() != null;
        String serverIp = this.getServerStatus(client, online);
        this.lastOnlineState = online;
        this.lastServerIp = serverIp;
        JsonObject json = new JsonObject();
        json.addProperty("type", "register");
        json.addProperty("player", this.playerName);
        json.addProperty("serverIp", serverIp);
        json.addProperty("online", Boolean.valueOf(online));
        kaqvuUtil.LOGGER.info("Register: player={}, serverIp={}, online={}", new Object[]{this.playerName, serverIp, online});
        this.webSocket.sendText(json.toString(), true);
    }

    public void disconnect() {
        if (this.webSocket != null) {
            try {
                this.webSocket.sendClose(1000, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.webSocket = null;
        this.registered = false;
        this.connecting = false;
    }

    public void sendPlayerInfo(JsonObject info) {
        if (this.webSocket == null || !this.registered) {
            return;
        }
        this.webSocket.sendText(info.toString(), true);
    }
}

