/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.util.network;

import java.net.http.WebSocket;
import java.util.concurrent.CompletionStage;
import pl.kaqvu.util.network.WebSocketManager;

public class WebSocketHandler
implements WebSocket.Listener {
    private final WebSocketManager manager;
    private final StringBuilder buffer = new StringBuilder();

    public WebSocketHandler(WebSocketManager manager) {
        this.manager = manager;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.manager.onConnected(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.buffer.append(data);
        if (last) {
            this.manager.onMessage(this.buffer.toString());
            this.buffer.setLength(0);
        }
        webSocket.request(1L);
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.manager.onClosed();
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        this.manager.onClosed();
    }
}

