/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.util.action;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import pl.kaqvu.util.kaqvuUtil;
import pl.kaqvu.util.mixin.PlayerInventoryAccessor;

public class ActionExecutor {
    private final Map<String, Boolean> movementStates = new HashMap<String, Boolean>();

    public void execute(String type, JsonObject json, class_310 client, class_746 player) {
        switch (type) {
            case "chat": {
                this.executeChat(json, player);
                break;
            }
            case "execute": {
                this.executeCommand(json, player);
                break;
            }
            case "disconnect": {
                this.executeDisconnect(player);
                break;
            }
            case "setSlot": {
                this.executeSetSlot(json, player);
                break;
            }
            case "leftClick": {
                this.executeLeftClick(client, player);
                break;
            }
            case "rightClick": {
                this.executeRightClick(client, player);
                break;
            }
            case "guiClick": {
                this.executeGuiClick(json, client, player);
                break;
            }
            case "moveStart": {
                this.executeMoveStart(json, client);
                break;
            }
            case "moveStop": {
                this.executeMoveStop(json, client);
                break;
            }
            case "dropItem": {
                this.executeDropItem(json, player);
                break;
            }
            case "getInfo": {
                this.executeGetInfo(player);
            }
        }
    }

    private void executeChat(JsonObject json, class_746 player) {
        String msg = json.get("message").getAsString();
        player.field_3944.method_45729(msg);
    }

    private void executeCommand(JsonObject json, class_746 player) {
        String cmd = json.get("command").getAsString();
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        player.field_3944.method_45730(cmd);
    }

    private void executeDisconnect(class_746 player) {
        kaqvuUtil.getInstance().getWsManager().disconnect();
        player.field_3944.method_48296().method_10747((class_2561)class_2561.method_43470((String)"Disconnected"));
    }

    private void executeSetSlot(JsonObject json, class_746 player) {
        int slot = json.get("slot").getAsInt();
        if (slot < 0 || slot > 8) {
            return;
        }
        ((PlayerInventoryAccessor)player.method_31548()).setSelectedSlot(slot);
        player.field_3944.method_52787((class_2596)new class_2868(slot));
    }

    private void executeLeftClick(class_310 client, class_746 player) {
        if (client.field_1761 != null) {
            player.method_6104(class_1268.field_5808);
        }
    }

    private void executeRightClick(class_310 client, class_746 player) {
        if (client.field_1761 != null) {
            client.field_1761.method_2919((class_1657)player, class_1268.field_5808);
        }
    }

    private void executeGuiClick(JsonObject json, class_310 client, class_746 player) {
        int slotId = json.get("slot").getAsInt();
        int button = json.get("button").getAsInt();
        boolean shift = json.has("shift") && json.get("shift").getAsBoolean();
        class_437 class_4372 = client.field_1755;
        if (!(class_4372 instanceof class_465)) {
            kaqvuUtil.LOGGER.info("No GUI open");
            return;
        }
        class_465 screen = (class_465)class_4372;
        class_1703 handler = screen.method_17577();
        if (slotId < 0 || slotId >= handler.field_7761.size()) {
            kaqvuUtil.LOGGER.info("Invalid slot: {}", (Object)slotId);
            return;
        }
        class_1713 actionType = shift ? class_1713.field_7794 : class_1713.field_7790;
        client.field_1761.method_2906(handler.field_7763, slotId, button, actionType, (class_1657)player);
    }

    private void executeMoveStart(JsonObject json, class_310 client) {
        String direction = json.get("direction").getAsString();
        class_304 keyBinding = this.getKeyBindingForDirection(direction, client);
        if (keyBinding == null) {
            return;
        }
        this.movementStates.put(direction, true);
        keyBinding.method_23481(true);
    }

    private void executeMoveStop(JsonObject json, class_310 client) {
        String direction = json.get("direction").getAsString();
        class_304 keyBinding = this.getKeyBindingForDirection(direction, client);
        if (keyBinding == null) {
            return;
        }
        keyBinding.method_23481(false);
        this.movementStates.put(direction, false);
    }

    private class_304 getKeyBindingForDirection(String direction, class_310 client) {
        return switch (direction) {
            case "forward" -> client.field_1690.field_1894;
            case "backward" -> client.field_1690.field_1881;
            case "left" -> client.field_1690.field_1913;
            case "right" -> client.field_1690.field_1849;
            case "jump" -> client.field_1690.field_1903;
            case "sneak" -> client.field_1690.field_1832;
            default -> null;
        };
    }

    private void executeDropItem(JsonObject json, class_746 player) {
        boolean stack = json.has("stack") && json.get("stack").getAsBoolean();
        player.method_7290(stack);
    }

    private void executeGetInfo(class_746 player) {
        JsonObject info = new JsonObject();
        info.addProperty("type", "playerInfo");
        info.addProperty("health", (Number)Float.valueOf(player.method_6032()));
        info.addProperty("maxHealth", (Number)Float.valueOf(player.method_6063()));
        info.addProperty("hunger", (Number)player.method_7344().method_7586());
        info.addProperty("x", (Number)player.method_23317());
        info.addProperty("y", (Number)player.method_23318());
        info.addProperty("z", (Number)player.method_23321());
        kaqvuUtil.getInstance().getWsManager().sendPlayerInfo(info);
    }
}

