/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.reconnect.handler;

import java.util.Random;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaqvu.reconnect.alwaysflags.AlwaysFlagRegistry;
import pl.kaqvu.reconnect.config.ReconnectConfig;
import pl.kaqvu.reconnect.flags.FlagRegistry;

public class ReconnectHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"kaqvuReconnect");
    private static final int AUTOLOGIN_DELAY = 3;
    private static final int FLAG_DELAY = 5;
    private static final int ANTI_AFK_WAIT_DELAY = 10;
    private static final int ANTI_AFK_DURATION = 10;
    private static final int ANTI_AFK_LOOK_DURATION = 40;
    private final ReconnectConfig config;
    private final Random random = new Random();
    private int tickCounter = 0;
    private int antiAfkWaitCounter = 0;
    private boolean shouldReconnect = false;
    private boolean shouldAutologin = false;
    private boolean shouldWaitBeforeAntiAfk = false;
    private boolean shouldAntiAfk = false;
    private boolean shouldExecuteFlags = false;
    private boolean alwaysFlagsActive = false;
    private boolean isFirstJoinAfterReconnect = false;
    private int antiAfkTicksRemaining = 0;
    private boolean antiAfkLookingDown = false;
    private float antiAfkTargetPitch = 0.0f;
    private float antiAfkTargetYaw = 0.0f;
    private float antiAfkStartPitch = 0.0f;
    private float antiAfkStartYaw = 0.0f;
    private int antiAfkLookTicks = 0;
    private int currentFlagIndex = 0;
    private class_642 lastServer = null;
    private float microMovementPhase = 0.0f;
    private int nextJumpTick = 0;

    public ReconnectHandler(ReconnectConfig config) {
        this.config = config;
    }

    public void register() {
        this.registerJoinEvent();
        this.registerDisconnectEvent();
        this.registerTickEvent();
    }

    private void registerJoinEvent() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_642 serverInfo = handler.method_45734();
            if (serverInfo != null) {
                this.lastServer = new class_642(serverInfo.field_3752, serverInfo.field_3761, class_642.class_8678.field_45611);
                this.lastServer.method_2995(class_642.class_643.field_3768);
                LOGGER.info("Saved server info: {}", (Object)serverInfo.field_3761);
            }
            if (this.config.isToggleEnabled()) {
                client.field_1690.field_1837 = false;
                LOGGER.info("Disabled pause on lost focus for background operation");
            }
            if (this.isFirstJoinAfterReconnect) {
                this.tickCounter = 0;
                if (!this.config.getAutologinPassword().isEmpty()) {
                    this.shouldAutologin = true;
                    LOGGER.info("Starting autologin timer...");
                } else if (this.config.isAntiAfkEnabled()) {
                    this.startAntiAfkWait();
                } else if (!this.config.getFlags().isEmpty()) {
                    this.shouldExecuteFlags = true;
                    this.currentFlagIndex = 0;
                    LOGGER.info("Starting flags execution...");
                }
                this.isFirstJoinAfterReconnect = false;
            }
        });
    }

    private void registerDisconnectEvent() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (this.alwaysFlagsActive) {
                AlwaysFlagRegistry.stopAll(client);
                this.alwaysFlagsActive = false;
            }
            if (this.config.isToggleEnabled() && this.lastServer != null) {
                LOGGER.info("Disconnected from server, will reconnect in {} seconds", (Object)this.config.getReconnectDelay());
                this.shouldReconnect = true;
                this.tickCounter = 0;
            }
        });
    }

    private void registerTickEvent() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
    }

    private void onTick(class_310 client) {
        this.handleReconnect(client);
        this.handleAutologin(client);
        this.handleAntiAfkWait(client);
        this.handleAntiAfk(client);
        this.handleFlags(client);
        this.handleAlwaysFlags(client);
    }

    private void handleReconnect(class_310 client) {
        if (this.shouldReconnect) {
            ++this.tickCounter;
            if (this.tickCounter >= this.config.getReconnectDelay() * 20) {
                LOGGER.info("Reconnecting to server: {}", (Object)this.lastServer.field_3761);
                this.reconnectToServer(client);
                this.shouldReconnect = false;
                this.shouldAutologin = false;
                this.shouldWaitBeforeAntiAfk = false;
                this.shouldAntiAfk = false;
                this.shouldExecuteFlags = false;
                this.isFirstJoinAfterReconnect = true;
                this.tickCounter = 0;
            }
        }
    }

    private void handleAutologin(class_310 client) {
        if (!this.shouldAutologin || this.config.getAutologinPassword().isEmpty() || client.field_1724 == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter == 1) {
            LOGGER.info("Autologin timer started, waiting {} seconds...", (Object)3);
        }
        if (this.tickCounter >= 60) {
            LOGGER.info("Sending autologin command: /login {}", (Object)"*".repeat(this.config.getAutologinPassword().length()));
            client.method_1562().method_45730("login " + this.config.getAutologinPassword());
            this.shouldAutologin = false;
            this.tickCounter = 0;
            if (this.config.isAntiAfkEnabled()) {
                this.startAntiAfkWait();
            } else if (!this.config.getFlags().isEmpty()) {
                this.shouldExecuteFlags = true;
                this.currentFlagIndex = 0;
                LOGGER.info("Starting flags execution after autologin...");
            }
        }
    }

    private void startAntiAfkWait() {
        this.shouldWaitBeforeAntiAfk = true;
        this.antiAfkWaitCounter = 0;
        LOGGER.info("Waiting {} seconds before starting anti-afk...", (Object)10);
    }

    private void handleAntiAfkWait(class_310 client) {
        if (!this.shouldWaitBeforeAntiAfk || client.field_1724 == null) {
            return;
        }
        ++this.antiAfkWaitCounter;
        if (this.antiAfkWaitCounter >= 200) {
            this.shouldWaitBeforeAntiAfk = false;
            this.antiAfkWaitCounter = 0;
            this.startAntiAfk(client);
        }
    }

    private void startAntiAfk(class_310 client) {
        this.shouldAntiAfk = true;
        this.antiAfkTicksRemaining = 200;
        this.antiAfkLookingDown = false;
        this.antiAfkLookTicks = 0;
        this.microMovementPhase = this.random.nextFloat() * 100.0f;
        this.antiAfkStartPitch = client.field_1724.method_36455();
        this.antiAfkStartYaw = client.field_1724.method_36454();
        float pitchOffset = 20.0f + this.random.nextFloat() * 40.0f;
        float yawOffset = -60.0f + this.random.nextFloat() * 120.0f;
        this.antiAfkTargetPitch = this.antiAfkStartPitch + pitchOffset;
        this.antiAfkTargetYaw = this.antiAfkStartYaw + yawOffset;
        if (this.antiAfkTargetPitch > 90.0f) {
            this.antiAfkTargetPitch = 90.0f;
        }
        if (this.antiAfkTargetPitch < -90.0f) {
            this.antiAfkTargetPitch = -90.0f;
        }
        LOGGER.info("Anti-AFK started with random direction (pitch: {}, yaw: {})", (Object)String.format("%.1f", Float.valueOf(pitchOffset)), (Object)String.format("%.1f", Float.valueOf(yawOffset)));
    }

    private void handleAntiAfk(class_310 client) {
        if (!this.shouldAntiAfk || client.field_1724 == null) {
            return;
        }
        if (!this.antiAfkLookingDown) {
            ++this.antiAfkLookTicks;
            float baseProgress = (float)this.antiAfkLookTicks / 40.0f;
            float smoothProgress = this.humanizedEase(baseProgress);
            float jitter = (float)Math.sin((double)this.antiAfkLookTicks * 0.3) * 0.02f * (1.0f - baseProgress);
            smoothProgress = Math.max(0.0f, Math.min(1.0f, smoothProgress + jitter));
            float currentPitch = this.antiAfkStartPitch + (this.antiAfkTargetPitch - this.antiAfkStartPitch) * smoothProgress;
            float currentYaw = this.antiAfkStartYaw + (this.antiAfkTargetYaw - this.antiAfkStartYaw) * smoothProgress;
            float microPitch = (float)Math.sin((double)this.antiAfkLookTicks * 0.15 + (double)this.microMovementPhase) * 0.3f;
            float microYaw = (float)Math.cos((double)this.antiAfkLookTicks * 0.12 + (double)(this.microMovementPhase * 1.3f)) * 0.4f;
            client.field_1724.method_36457(currentPitch + microPitch);
            client.field_1724.method_36456(currentYaw + microYaw);
            if (this.antiAfkLookTicks >= 40) {
                this.antiAfkLookingDown = true;
                this.nextJumpTick = this.antiAfkTicksRemaining - (10 + this.random.nextInt(20));
                LOGGER.info("Anti-AFK: Camera movement complete, starting alternating movement");
            }
        } else {
            int totalTicks = 200;
            int elapsedTicks = totalTicks - this.antiAfkTicksRemaining;
            int cycleLength = 40;
            boolean movingForward = elapsedTicks / cycleLength % 2 == 0;
            float yawRad = (float)Math.toRadians(client.field_1724.method_36454());
            double speed = 0.08;
            double direction = movingForward ? -1.0 : 1.0;
            double dx = Math.sin(yawRad) * speed * direction;
            double dz = -Math.cos(yawRad) * speed * direction;
            client.field_1724.method_5762(dx, 0.0, dz);
            if (this.antiAfkTicksRemaining <= this.nextJumpTick && client.field_1724.method_24828()) {
                client.field_1724.method_6043();
                this.nextJumpTick = this.antiAfkTicksRemaining - (15 + this.random.nextInt(25));
            }
            float walkMicroPitch = (float)Math.sin((double)this.antiAfkTicksRemaining * 0.08 + (double)this.microMovementPhase) * 0.2f;
            float walkMicroYaw = (float)Math.cos((double)this.antiAfkTicksRemaining * 0.05 + (double)(this.microMovementPhase * 0.7f)) * 0.3f;
            client.field_1724.method_36457(client.field_1724.method_36455() + walkMicroPitch);
            client.field_1724.method_36456(client.field_1724.method_36454() + (walkMicroYaw += (float)Math.sin((double)this.antiAfkTicksRemaining * 0.02) * 0.15f));
            --this.antiAfkTicksRemaining;
            if (this.antiAfkTicksRemaining <= 0) {
                this.shouldAntiAfk = false;
                this.antiAfkLookingDown = false;
                this.antiAfkLookTicks = 0;
                this.tickCounter = 0;
                LOGGER.info("Anti-AFK finished, now executing flags");
                if (!this.config.getFlags().isEmpty()) {
                    this.shouldExecuteFlags = true;
                    this.currentFlagIndex = 0;
                }
            }
        }
    }

    private float humanizedEase(float t) {
        float variation = 0.15f + this.random.nextFloat() * 0.1f;
        float adjusted = (float)Math.pow(t, 2.0 + (double)variation);
        float slowdown = 1.0f - (float)Math.pow(1.0f - t, 3.0);
        return adjusted * 0.4f + slowdown * 0.6f;
    }

    private void handleFlags(class_310 client) {
        if (!this.shouldExecuteFlags || this.config.getFlags().isEmpty() || this.shouldAutologin || this.shouldWaitBeforeAntiAfk || this.shouldAntiAfk || client.field_1724 == null) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 100) {
            if (this.currentFlagIndex < this.config.getFlags().size()) {
                FlagRegistry.executeFlag(client, this.config.getFlags().get(this.currentFlagIndex));
                ++this.currentFlagIndex;
                this.tickCounter = 0;
            } else {
                this.shouldExecuteFlags = false;
                this.currentFlagIndex = 0;
                LOGGER.info("All flags executed");
                if (AlwaysFlagRegistry.hasActiveFlags()) {
                    AlwaysFlagRegistry.startAll(client);
                    this.alwaysFlagsActive = true;
                }
            }
        }
    }

    private void reconnectToServer(class_310 client) {
        if (this.lastServer != null) {
            this.lastServer.method_2995(class_642.class_643.field_3768);
            class_639 serverAddress = class_639.method_2950((String)this.lastServer.field_3761);
            class_412.method_36877((class_437)new class_442(), (class_310)client, (class_639)serverAddress, (class_642)this.lastServer, (boolean)false, null);
        }
    }

    private void handleAlwaysFlags(class_310 client) {
        if (this.alwaysFlagsActive && client.field_1724 != null) {
            AlwaysFlagRegistry.tick(client);
        }
    }
}

