/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.reconnect.flags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaqvu.reconnect.flags.Flag;
import pl.kaqvu.reconnect.flags.GuiClickFlag;
import pl.kaqvu.reconnect.flags.LeftClickFlag;
import pl.kaqvu.reconnect.flags.RightClickFlag;
import pl.kaqvu.reconnect.flags.SetSlotFlag;

public class FlagRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"kaqvuReconnect");
    private static final Map<String, Flag> registeredFlags = new HashMap<String, Flag>();

    public static void register(Flag flag) {
        registeredFlags.put(flag.getName(), flag);
    }

    public static Flag getFlag(String name) {
        return registeredFlags.get(name);
    }

    public static boolean isValidFlag(String name) {
        return registeredFlags.containsKey(name);
    }

    public static List<String> getValidFlagNames() {
        return new ArrayList<String>(registeredFlags.keySet());
    }

    public static boolean executeFlag(class_310 client, String flagString) {
        String[] parts = flagString.split(" ", 2);
        String flagName = parts[0];
        String argument = parts.length > 1 ? parts[1] : null;
        Flag flag = FlagRegistry.getFlag(flagName);
        if (flag == null) {
            LOGGER.warn("Unknown flag: {}", (Object)flagName);
            return false;
        }
        LOGGER.info("Executing flag: {}", (Object)flagString);
        return flag.execute(client, argument);
    }

    static {
        FlagRegistry.register(new SetSlotFlag());
        FlagRegistry.register(new RightClickFlag());
        FlagRegistry.register(new LeftClickFlag());
        FlagRegistry.register(new GuiClickFlag());
    }
}

