/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.reconnect.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaqvu.reconnect.alwaysflags.AlwaysFlagRegistry;

public class ReconnectConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"kaqvuReconnect");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("kaqvuReconnect.properties");
    private boolean toggleEnabled = false;
    private String autologinPassword = "";
    private String flagsString = "";
    private String alwaysFlagsString = "";
    private int reconnectDelay = 5;
    private boolean antiAfkEnabled = false;
    private final List<String> flags = new ArrayList<String>();

    public void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Properties properties = new Properties();
            try {
                properties.load(Files.newInputStream(CONFIG_PATH, new OpenOption[0]));
                this.toggleEnabled = Boolean.parseBoolean(properties.getProperty("toggleEnabled", "false"));
                this.autologinPassword = properties.getProperty("autologinPassword", "");
                this.flagsString = properties.getProperty("flags", "");
                this.alwaysFlagsString = properties.getProperty("alwaysFlags", "");
                this.reconnectDelay = Integer.parseInt(properties.getProperty("reconnectDelay", "5"));
                this.antiAfkEnabled = Boolean.parseBoolean(properties.getProperty("antiAfkEnabled", "false"));
                this.parseFlags(this.flagsString);
                this.parseAlwaysFlags(this.alwaysFlagsString);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
    }

    public void save() {
        Properties properties = new Properties();
        properties.setProperty("toggleEnabled", String.valueOf(this.toggleEnabled));
        properties.setProperty("autologinPassword", this.autologinPassword);
        properties.setProperty("flags", this.flagsString);
        properties.setProperty("alwaysFlags", this.alwaysFlagsString);
        properties.setProperty("reconnectDelay", String.valueOf(this.reconnectDelay));
        properties.setProperty("antiAfkEnabled", String.valueOf(this.antiAfkEnabled));
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            properties.store(Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private void parseFlags(String flagStr) {
        this.flags.clear();
        if (flagStr == null || flagStr.isEmpty()) {
            return;
        }
        String[] parts = flagStr.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].startsWith("-")) continue;
            String flagName = parts[i];
            if (flagName.equals("-setslot") || flagName.equals("-guiclick")) {
                if (i + 1 >= parts.length) continue;
                this.flags.add(flagName + " " + parts[i + 1]);
                ++i;
                continue;
            }
            this.flags.add(flagName);
        }
    }

    private void parseAlwaysFlags(String flagStr) {
        ArrayList<String> alwaysFlags = new ArrayList<String>();
        if (flagStr != null && !flagStr.isEmpty()) {
            String[] parts;
            for (String part : parts = flagStr.split(" ")) {
                if (!part.startsWith("-") || !AlwaysFlagRegistry.isValidFlag(part)) continue;
                alwaysFlags.add(part);
            }
        }
        AlwaysFlagRegistry.setActiveFlags(alwaysFlags);
    }

    public boolean isToggleEnabled() {
        return this.toggleEnabled;
    }

    public void setToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
        this.save();
    }

    public String getAutologinPassword() {
        return this.autologinPassword;
    }

    public void setAutologinPassword(String autologinPassword) {
        this.autologinPassword = autologinPassword;
        this.save();
    }

    public String getFlagsString() {
        return this.flagsString;
    }

    public void setFlagsString(String flagsString) {
        this.flagsString = flagsString;
        this.parseFlags(flagsString);
        this.save();
    }

    public String getAlwaysFlagsString() {
        return this.alwaysFlagsString;
    }

    public void setAlwaysFlagsString(String alwaysFlagsString) {
        this.alwaysFlagsString = alwaysFlagsString;
        this.parseAlwaysFlags(alwaysFlagsString);
        this.save();
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        this.save();
    }

    public boolean isAntiAfkEnabled() {
        return this.antiAfkEnabled;
    }

    public void setAntiAfkEnabled(boolean antiAfkEnabled) {
        this.antiAfkEnabled = antiAfkEnabled;
        this.save();
    }

    public List<String> getFlags() {
        return this.flags;
    }
}

