/*
 * Decompiled with CFR 0.152.
 */
package pl.kaqvu.reconnect.alwaysflags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaqvu.reconnect.alwaysflags.AlwaysFlag;
import pl.kaqvu.reconnect.alwaysflags.JumpAlwaysFlag;
import pl.kaqvu.reconnect.alwaysflags.SneakAlwaysFlag;

public class AlwaysFlagRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"kaqvuReconnect");
    private static final Map<String, AlwaysFlag> registeredFlags = new HashMap<String, AlwaysFlag>();
    private static final List<String> activeFlags = new ArrayList<String>();
    private static final SneakAlwaysFlag sneakFlag = new SneakAlwaysFlag();
    private static final JumpAlwaysFlag jumpFlag = new JumpAlwaysFlag();

    public static void register(AlwaysFlag flag) {
        registeredFlags.put(flag.getName(), flag);
    }

    public static boolean isValidFlag(String name) {
        return registeredFlags.containsKey(name);
    }

    public static List<String> getValidFlagNames() {
        return new ArrayList<String>(registeredFlags.keySet());
    }

    public static List<String> getActiveFlags() {
        return new ArrayList<String>(activeFlags);
    }

    public static void setActiveFlags(List<String> flags) {
        activeFlags.clear();
        activeFlags.addAll(flags);
    }

    public static void startAll(class_310 client) {
        for (String flagName : activeFlags) {
            AlwaysFlag flag = registeredFlags.get(flagName);
            if (flag == null) continue;
            flag.start(client);
        }
        LOGGER.info("Started {} always flags", (Object)activeFlags.size());
    }

    public static void stopAll(class_310 client) {
        sneakFlag.stop(client);
        jumpFlag.stop(client);
        LOGGER.info("Stopped all always flags");
    }

    public static void tick(class_310 client) {
        if (activeFlags.contains("-sneak")) {
            sneakFlag.tick(client);
        }
        if (activeFlags.contains("-jump")) {
            jumpFlag.tick(client);
        }
    }

    public static boolean hasActiveFlags() {
        return !activeFlags.isEmpty();
    }

    static {
        AlwaysFlagRegistry.register(sneakFlag);
        AlwaysFlagRegistry.register(jumpFlag);
    }
}

